var React = require('react');
var BemMixin = require('./BemMixin');

var PropTypes = React.PropTypes;

var Dropdown = React.createClass({
    displayName: 'Dropdown',
    mixins: [BemMixin],

    сhildrenContainer: function(block) {
        return block.getPopup().elem('content')[0];
    }
});

// @ifdef DEBUG
Dropdown.propTypes = {
    disabled: PropTypes.bool,
    mod: PropTypes.string,
    opened: PropTypes.bool,
    switcher: PropTypes.oneOf(['link', 'button']),
    size: PropTypes.oneOf(['s', 'm', 'l', 'xl']),
    text: PropTypes.string,
    theme: PropTypes.oneOf(['islands'])
};
// @endif

Dropdown.propsMap = {
    mods: {
        disabled: null,
        opened: null,
        size: null,
        switcher: null,
        theme: null
    },
    text: ['switcher'],
    children: ['popup']
};

Dropdown.defaultProps = {
    size: 'm',
    theme: 'islands',
    switcher: 'button'
};

module.exports = Dropdown;
