var React = require('react');
var BemMixin = require('./BemMixin');
var BemInputMixin = require('./BemInputMixin');

var PropTypes = React.PropTypes;

var Input = React.createClass({
    displayName: 'Input',
    mixins: [BemMixin, BemInputMixin]
});

// @ifdef DEBUG
Input.propTypes = {
    autoComplete: PropTypes.bool,
    disabled: PropTypes.bool,
    hasClear: PropTypes.bool,
    id: PropTypes.string,
    maxLength: PropTypes.number,
    mod: PropTypes.string,
    name: PropTypes.string,
    onBlur: PropTypes.func,
    onChange: PropTypes.func,
    onFocus: PropTypes.func,
    onKeyDown: PropTypes.func,
    placeholder: PropTypes.string,
    size: PropTypes.oneOf(['s', 'm', 'l', 'xl']),
    tabIndex: PropTypes.number,
    type: PropTypes.oneOf(['password', 'search']),
    value: PropTypes.string,
    width: PropTypes.oneOf(['available'])
};
// @endif

Input.propsMap = {
    mods: {
        disabled: null,
        hasClear: ['has-clear'],
        size: null,
        theme: null,
        type: null,
        width: null
    },
    autoComplete: ['autocomplete'],
    id: null,
    maxLength: null,
    name: null,
    placeholder: null,
    tabIndex: null,
    val: [null, 'setVal']
};

Input.defaultProps = {
    size: 'm',
    theme: 'islands'
};

module.exports = Input;
