var React = require('react');
var BemMixin = require('./BemMixin');

var PropTypes = React.PropTypes;

var Link = React.createClass({
    mixins: [BemMixin],
    displayName: 'Link',

    blockDidMount: function(block) {
        block.on('click', function() {
            this.callHandler('click', {target: block});
        }.bind(this));
    }
});

// @ifdef DEBUG
Link.propTypes = {
    disabled: PropTypes.bool,
    mod: PropTypes.string,
    onClick: PropTypes.func,
    pseudo: PropTypes.bool,
    size: PropTypes.oneOf(['s', 'm', 'l', 'xl']),
    tabIndex: PropTypes.number,
    target: PropTypes.oneOf(['_blank', '_self', '_parent', '_top']),
    text: PropTypes.string,
    theme: PropTypes.oneOf(['islands']),
    title: PropTypes.string,
    url: PropTypes.string,
    view: PropTypes.oneOf(['minor', 'external'])
};
// @endif

Link.propsMap = {
    mods: {
        disabled: null,
        focused: null,
        pseudo: null,
        size: null,
        theme: null,
        view: null
    },
    url: [null, 'setUrl'],
    title: null,
    target: null,
    tabIndex: null,
    text: ['content']
};

Link.defaultProps = {
    size: 'm',
    theme: 'islands'
};

module.exports = Link;
