var React = require('react');
var BemMixin = require('./BemMixin');
var BemPopupMixin = require('./BemPopupMixin');

var PropTypes = React.PropTypes;

var Modal = React.createClass({
    displayName: 'Modal',
    mixins: [BemMixin, BemPopupMixin],

    childrenContainer: 'content',

    nested: false
});

// @ifdef DEBUG
Modal.propTypes = {
    closable: PropTypes.bool,
    mod: PropTypes.string,
    theme: PropTypes.oneOf(['islands']),
    visible: PropTypes.bool,
    zIndex: PropTypes.number
};
// @endif

Modal.propsMap = {
    mods: {
        closable: ['autoclosable'],
        theme: null,
        visible: null
    },
    zIndex: ['zIndexGroupLevel']
};

Modal.defaultProps = {
    theme: 'islands'
};

module.exports = Modal;
