var React = require('react');
var BemMixin = require('./BemMixin');
var BemPopupMixin = require('./BemPopupMixin');
var config = require('./config');

var PropTypes = React.PropTypes;

var Popup = React.createClass({
    displayName: 'Popup',
    mixins: [BemMixin, BemPopupMixin],

    childrenContainer: function(block) {
        return block.domElem[0];
    },

    nested: false,

    redraw: function() {
        this.block.redraw.apply(this.block, arguments);
    },

    setAnchor: function(anchor) {
        var $anchor = config.jQuery(anchor);

        this.block.setAnchor($anchor);
    },

    setPosition: function() {
        this.block.setPosition.apply(this.block, arguments);
    }
});

// @ifdef DEBUG
Popup.propTypes = {
    closable: PropTypes.bool,
    directions: PropTypes.array,
    mainOffset: PropTypes.number,
    mod: PropTypes.string,
    secondaryOffset: PropTypes.number,
    target: PropTypes.oneOf(['anchor', 'position']).isRequired,
    theme: PropTypes.oneOf(['islands']),
    viewportOffset: PropTypes.number,
    visible: PropTypes.bool,
    zIndex: PropTypes.number
};
// @endif

Popup.propsMap = {
    mods: {
        closable: ['autoclosable'],
        target: null,
        theme: null,
        visible: null
    },
    directions: null,
    mainOffset: null,
    secondaryOffset: null,
    viewportOffset: null,
    zIndex: ['zIndexGroupLevel']
};

Popup.defaultProps = {
    theme: 'islands'
};

module.exports = Popup;
