var React = require('react');
var BemMixin = require('./BemMixin');

var PropTypes = React.PropTypes;

var Radiogroup = React.createClass({
    displayName: 'Radiogroup',
    blockName: 'radio-group',
    mixins: [BemMixin],

    blockDidMount: function(block) {
        block.on('change', function() {
            this.callHandler('change', {
                target: block,
                value: block.getVal()
            });
        }.bind(this));
    }
});

// @ifdef DEBUG
Radiogroup.propTypes = {
    disabled: PropTypes.bool,
    mod: PropTypes.string,
    name: PropTypes.string,
    options: PropTypes.array,
    size: PropTypes.oneOf(['m', 'l']),
    theme: PropTypes.oneOf(['islands']),
    type: PropTypes.oneOf(['button', 'line']),
    val: PropTypes.oneOfType([
        PropTypes.string,
        PropTypes.number
    ])
};
// @endif

Radiogroup.propsMap = {
    mods: {
        disabled: null,
        size: null,
        theme: null,
        type: null
    },
    name: null,
    options: null,
    val: [null, 'setVal']
};

Radiogroup.defaultProps = {
    size: 'm',
    theme: 'islands'
};

module.exports = Radiogroup;
