var React = require('react');
var BemMixin = require('./BemMixin');
var BemInputMixin = require('./BemInputMixin');

var PropTypes = React.PropTypes;

var Select = React.createClass({
    displayName: 'Select',
    mixins: [BemMixin, BemInputMixin]
});

// @ifdef DEBUG
Select.propTypes = {
    disabled: PropTypes.bool,
    id: PropTypes.string,
    maxHeight: PropTypes.number,
    mod: PropTypes.string,
    mode: PropTypes.oneOf(['check', 'radio', 'radio-check']),
    name: PropTypes.string,
    options: PropTypes.array,
    size: PropTypes.oneOf(['s', 'm', 'l', 'xl']),
    tabIndex: PropTypes.number,
    text: PropTypes.string,
    theme: PropTypes.oneOf(['islands']),
    val: PropTypes.oneOfType([
        PropTypes.array,
        PropTypes.number,
        PropTypes.string
    ]),
    width: PropTypes.oneOf(['available'])
};
// @endif

Select.propsMap = {
    mods: {
        disabled: null,
        mode: null,
        size: null,
        theme: null,
        width: null
    },
    name: null,
    options: null,
    text: null,
    val: [null, 'setVal'],
    maxHeight: ['optionsMaxHeight']
};

Select.defaultProps = {
    mode: 'radio',
    size: 'm',
    theme: 'islands'
};

module.exports = Select;
