var React = require('react');
var BemMixin = require('./BemMixin');
var BemInputMixin = require('./BemInputMixin');

var PropTypes = React.PropTypes;

var Textarea = React.createClass({
    displayName: 'Textarea',
    mixins: [BemMixin, BemInputMixin]
});

// @ifdef DEBUG
Textarea.propTypes = {
    disabled: PropTypes.bool,
    id: PropTypes.string,
    mod: PropTypes.string,
    name: PropTypes.string,
    onBlur: PropTypes.func,
    onChange: PropTypes.func,
    onFocus: PropTypes.func,
    onKeyDown: PropTypes.func,
    placeholder: PropTypes.string,
    size: PropTypes.oneOf(['s', 'm', 'l', 'xl']),
    tabIndex: PropTypes.number,
    theme: PropTypes.oneOf(['islands']),
    val: PropTypes.string,
    width: PropTypes.oneOf(['available'])
};
// @endif

Textarea.propsMap = {
    mods: {
        disabled: null,
        size: null,
        theme: null,
        width: null
    },
    id: null,
    name: null,
    placeholder: null,
    tabIndex: null,
    val: [null, 'setVal']
};

Textarea.defaultProps = {
    size: 'm',
    theme: 'islands'
};

module.exports = Textarea;
