var DOMPropsConfig = require('./DOMPropsConfig');

/**
 * Конвертирует HTML атрибуты в react-совместимые свойства
 * @method normalizeProps
 * @param  {Object}       data
 * @return {Object}
 */
var normalizeProps = function(data) {
    var props = {};

    for (var key in data) {
        if (!data.hasOwnProperty(key)) {
            continue;
        }

        var value = data[key];

        key = key.toLowerCase();

        // React не поддерживает инлайновые стили в формате строки
        if (key === 'style') {
            continue;
        }

        key = DOMPropsConfig[key] || key;

        props[key] = value;
    }

    return props;
};

module.exports = normalizeProps;
