import React from 'react';
import { block } from 'bem-cn';

import './Logo.css';

const bHeader = block('header');

export default ({ cls, src, text, url, target, onClick, custom }) => {
    let className = bHeader('logo', { custom }).mix(cls);
    let content = src ? <img className={bHeader('logo-image')} src={src} alt={text}/> : text;

    if (!url) {
        return (
            <span
                className={className}
                onClick={onClick}
            >
                {content}
            </span>
        );
    }

    return (
        <a
            className={className}
            href={url}
            target={target}
            rel="noopener noreferrer"
            onClick={onClick}
        >
            {content}
        </a>
    );
};
