import React from 'react';

export default ({ id, url, target, onClick, cls, children }) => {
    if (!url) {
        return (
            <span
                className={cls}
                onClick={onClick}
                data-id={id}
            >
                {children}
            </span>
        );
    }

    return (
        <a 
            className={cls}
            href={url}
            target={target}
            rel="noopener noreferrer"
            onClick={onClick}
            data-id={id}
        >
            {children}
        </a>
    );
};
