import React from 'react';
import buildUrl from '@connect/url-placeholders';
import { block } from 'bem-cn';

const bUser = block('user');

const Defaults = {
    avatarUrl: 'https://yapic.yandex.net/get/${id}/islands-${size}'
};

export default ({ uid, name, cls, onClick, avatarUrl = Defaults.avatarUrl, avatarId }) => (
    <span
        className={bUser({}).mix(cls)}
        onClick={onClick}
    >
        <span
            className={bUser('avatar')}
            style={{ backgroundImage: `url(${buildUrl(avatarUrl, { id: avatarId, size: 200 })})` }}
        />
        <span className={bUser('name')}>
            {name}
        </span>
    </span>
);
