import React from 'react';
import User from './User';
import MenuItem from './MenuItem';
import MultiSessionList from './MultiSessionList';
import { block } from 'bem-cn';

import './UserWidget.css';

const bHeader = block('header');

export default class extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            open: props.initialOpen || false
        };

        this._initButton = this._initButton.bind(this);
        this._initPopup = this._initPopup.bind(this);

        this._onClick = this._onClick.bind(this);
        this._onOutsideClick = this._onOutsideClick.bind(this);
    }

    componentDidMount() {
        document.body.addEventListener('click', this._onOutsideClick);
    }

    componentWillUnmount() {
        document.body.removeEventListener('click', this._onOutsideClick);
    }

    _initPopup(element) {
        if (!this._popup) {
            this._popup = element;
        }
    }

    _initButton(element) {
        if (!this._button) {
            this._button = element;
        }
    }

    _onClick() {
        this.setState({
            open: !this.state.open
        });
    }

    _onOutsideClick({ target }) {
        let isPopupClick = this._popup && this._popup.contains(target);
        let isButtonClick = this._button && this._button.contains(target);

        if (!isPopupClick && !isButtonClick) {
            this.setState({
                open: false
            });
        }
    }

    render() {
        let {
            uid,
            name,
            accounts,
            maxAccounts,
            passportHost,
            passportRetpath,
            avatarUrl,
            addAccount,
            addAccountCaption,
            children
        } = this.props;

        let currentAccount = (Array.isArray(accounts) ? accounts.find(({ id }) => id === uid) : null) || {};

        return (
            <div className={bHeader('user-widget', { open: this.state.open })}
                onClick={this._onClick}
                ref={this._initButton}
            >
                <User
                    cls={bHeader('current-user')}
                    uid={uid}
                    name={name || currentAccount.login}
                    avatarId={currentAccount.avatar_id}
                    avatarUrl={avatarUrl}
                />
                <div
                    className={bHeader('user-widget-menu')}
                    ref={this._initPopup}
                >
                    <MultiSessionList
                        cls={bHeader('user-widget-list')}
                        accounts={accounts.filter(({ id }) => id !== uid).slice(0, maxAccounts)}
                        passportHost={passportHost}
                        passportRetpath={passportRetpath}
                        addAccount={addAccount}
                        addAccountCaption={addAccountCaption}
                        avatarUrl={avatarUrl}
                    />
                    {children}
                </div>
            </div>
        );
    }
}
