import React from 'react';
import LogoMenu from './LogoMenu';
import Logo from './Logo';
import UserWidget from './UserWidget';
import { block } from 'bem-cn';

import './index.css';

const bHeader = block('header');

const Header = ({ cls, busy, borderless, children }) => (
    <div className={bHeader({ busy, borderless }).mix(cls)}>
        {children}
    </div>
);

Header.LogoMenu = LogoMenu;
Header.MainLogo = props => <Logo {...props} cls={bHeader('main-logo')}/>;
Header.SecondaryLogo = props => <Logo {...props} cls={bHeader('secondary-logo')}/>;
Header.NavLinks = ({ children }) => <div className={bHeader('nav-links')}>{children}</div>;
Header.FlexSpace = () => <div className={bHeader('flex-space')}/>;
Header.UserWidget = UserWidget;

export default Header;
