import React, {PropTypes} from 'react';

var Avatar = React.createClass({

    render: function() {
        var size = Number(this.props.size);
        var className = 'avatar';
        var style = {};

        if (this.props.url) {
            style.backgroundImage = 'url(' + this.props.url + ')';
        }

        if (!isNaN(size)) {
            style.width = size + 'px';
            style.height = size + 'px';

        } else {
            className += ' avatar_size_' + this.props.size;
        }

        return <div className={className} style={style} />;
    }
});

Avatar.propTypes = {
    size: PropTypes.oneOfType([
        PropTypes.number,
        PropTypes.oneOf(['xxs', 'xs', 's', 'm', 'l', 'xl', 'xxl'])
    ]),
    url: PropTypes.string
};

Avatar.defaultProps = {
    size: 'm'
};

export default Avatar;
