import React, { PropTypes } from 'react';
import classSet from 'classnames';
import Spin from 'react-bem-components/lib/Spin';

var Loader = React.createClass({
    displayName: 'Loader',

    render: function() {
        var className = classSet({
            'loader': true,
            'loader_visible': this.props.visible,
            'loader_transparent': this.props.transparent
        });

        return (
            <div className={className}>
                <Spin visible={true} size={this.props.size} />
            </div>
        );
    }
});

Loader.propTypes = {
    visible: PropTypes.bool,
    transparent: PropTypes.bool
};

Loader.defaultProps = {
    transparent: true
};

export default Loader;
