import React, { PropTypes } from 'react';
import classSet from 'classnames';
import Avatar from '../Avatar';

var Member = React.createClass({
    displayName: 'Member',

    render: function () {
        var props = this.props;
        var avatar = null;

        if (props.avatar) {
            avatar = (
                <div className="member__avatar">
                    <Avatar url={props.avatar} size="s" />
                </div>
            );
        }

        var className = classSet({
            member: true,
            member_primary: props.primary
        })

        var titleClassName = classSet({
            member__title: true,
            member__title_link: props.onTitleClick
        });

        return (
            <div className={className}>
                {avatar}
                <div className="member__details">
                    <div className={titleClassName}
                        title={props.tooltip ? props.title : null}
                        onClick={props.onTitleClick}>
                        {props.title}
                    </div>
                    <div className="member__description"
                        title={props.tooltip ? props.description : null}>
                        {props.description}
                    </div>
                </div>
            </div>
        );
    }
});

Member.defaultProps = {
    tooltip: true
};

Member.propTypes = {
    avatar: PropTypes.string,
    description: PropTypes.string,
    onTitleClick: PropTypes.func,
    primary: PropTypes.bool,
    title: PropTypes.string.isRequired,
    tooltip: PropTypes.bool
};

export default Member;
