import React, { PropTypes } from 'react';
import classSet from 'classnames';

import Avatar from '../Avatar';

var PickerItem = React.createClass({
    displayName: 'PickerItem',

    render: function () {
        var props = this.props;

        var className = classSet({
            'picker-item': true,
            'picker-item_selected': props.selected,
            [ 'picker-item_type_' + props.type ]: props.type
        });

        var avatar = null;

        if (props.avatar) {
            avatar = (
                <div className="picker-item__avatar">
                    <Avatar url={props.avatar} size="xxs" />
                </div>
            );
        }

        return (
            <div className={className}>
                {avatar}
                <div className="picker-item__title">
                    {props.title}
                </div>
                <div className="picker-item__close" />
            </div>
        );
    }
});

PickerItem.propTypes = {
    avatar: PropTypes.string,
    type: PropTypes.string,
    title: PropTypes.string.isRequired,
    selected: PropTypes.bool
};

export default PickerItem;
