/**
 * @author  @aandrosov
 */

const REG_MONOGRAM_SPLIT = /[^a-zа-яё0-9]/i;
const REG_MONOGRAM_SANITIZED = /['"()<>]/g;
const REG_MONOGRAM_MAIL = /^[a-zа-яё0-9]/i;
const REG_CAPITALS = /[A-ZА-ЯЁ]/g;

/**
 * Формирует монограмму из строки без кодировки
 * @param   {String} str Строка для формирования монограммы
 * @returns {String}     Сформированная монограмма
 */
function extractMonogram(str) {
    if (!str) {
        return;
    }

    str = String(str);
    str = str.replace(REG_MONOGRAM_SANITIZED, '');

    if (!str) {
        return;
    }

    var strParts = str.split(REG_MONOGRAM_SPLIT);
    var capitals = strParts[0].match(REG_CAPITALS) || [];

    if (capitals.length) {
        // если первая буква оригинальной строки прописная, то удаляем ее из массива матчей
        if (str.charAt(0).match(REG_CAPITALS)) {
            capitals = capitals.slice(1);
        }
    }

    // dydka2@yandex.ru -> D
    if (str.indexOf('@') !== -1 && REG_MONOGRAM_MAIL.test(str)) {
        str = str.charAt(0);
    // db -> DB
    } else if (strParts[0].length === 2) {
        str = strParts[0];
    // iBookStore.ru -> IB
    } else if (capitals.length) {
        str = strParts[0].charAt(0) + capitals[0];
    // Book Store -> BS
    } else if (strParts.length > 1) {
        str = strParts[0].charAt(0) + strParts[1].charAt(0);
    } else {
        str = strParts[0].charAt(0);
    }

    return str.toUpperCase();
}

export default extractMonogram;
