import avatarTemplate from './avatar.dot';

/**
 * Создает svg изображение аватарки
 * @method generateAvatarImage
 * @param   {String}            fill      Цвет заливки в hex
 * @param   {String}            initials  Инициалы
 * @returns {String}                      Изображение в base64
 */
function generateAvatarImage(fill = '#fff', initials) {
    if (initials) {
        initials = unescape(encodeURI(initials));
    }

    var svg = avatarTemplate({
        fill,
        initials
    });

    return 'data:image/svg+xml;base64,' + btoa(svg);
}

export default generateAvatarImage;
