/**
 * Базовый цвет, определяющий цветовую схему
 * @type {Array}
 */
const SCHEME = [ 128, 128, 128 ];

/**
 * Генерирует цвет на основе кодов первых символов
 * @method generateColor
 * @param   {String}       chars
 * @returns {String}              Значение в hex
 */
function generateColor(chars) {
    chars = String(chars).trim();

    var seed = '';

    for (let i = 0; i < chars.length; i++) {
        seed += chars.charCodeAt(i);
    }

    var color = '#';

    for (let i = 0; i < 3; i++) {
        let ratio = Math.abs((Math.sin(seed + i) * 10000)) % 256;
        let hex = Math.round((ratio + SCHEME[i]) / 2).toString(16);

        if (hex.length === 1) {
            hex = '0' + hex;
        }

        color += hex;
    }

    return color;
}

export default generateColor;
