module.exports = {
    rules: {
        complexity: [
            'error',
            23, // TODO 6 https://st.yandex-team.ru/DIR-6198
        ],
        'no-negated-condition': [
            'off', // TODO 'error' https://st.yandex-team.ru/DIR-6205
        ],
        'consistent-return': [
            'off', // TODO 'error' https://st.yandex-team.ru/DIR-6214
        ],
    },
    extends: [
        '../.eslintrc.js',
    ],
    globals: {
        Ya: false,
    },
    settings: {
        'import/resolver': {
            node: {},
            webpack: {},
        },
    },
    overrides: [
        {
            // legacy
            files: [
                'client/lib/**',
                'client/ui/**',
                'client/lego-ui/**',
                'client/services/**',
                'client/actions/**',
                'client/api/**',
                'client/components/**',
            ],
            excludedFiles: [
                'client/components/TooltipBox/**',
                'client/components/Icon/**',
                'client/components/ServiceDetails/**',
            ],
            rules: {
                'react/forbid-prop-types': 'off',
                'react/no-find-dom-node': 'off',
                'react/jsx-no-bind': 'off',
                'no-use-before-define': 'off',
            },
            globals: {
                React: false,
                modules: false,
            },
        },
        // Специфичные правила для hermione тестов
        {
            files: ['tests/hermione/suites/**'],
            rules: {
                // http://eslint.org/docs/rules/max-nested-callbacks
                'max-nested-callbacks': 'off',
            },
        },
    ],
};
