const defaultConfig = require('@yandex-int/clement/default-config');
const { sourceRequest, sourceResponse, cacheFilePath, cacheFileName, cacheKey } = require('./cache-helpers');
const controllers = require('./controllers');

module.exports = {
    plugins: [
        cacheFilePath,
        cacheFileName,
        cacheKey.common,
        sourceRequest,
        ...defaultConfig.plugins,
        sourceResponse,
    ],
    sources: {
        '3350': {
            url: 'https://pass-test.yandex.ru/blackbox',
            configs: {
                cacheName: 'blackbox',
                path: /.*/,
                plugins: [
                    cacheKey.passport,
                ],
            },
        },
        '3351': {
            url: 'https://api-internal-test.directory.ws.yandex.net',
            configs: {
                cacheName: 'directory',
                path: /.*/,
                plugins: [
                    controllers.directory,
                ],
            },
        },
        '3352': {
            url: 'https://settings-test.ws.yandex.ru',
            configs: {
                cacheName: 'settings',
                path: /.*/,
            },
        },
        '3354': {
            url: 'https://connect-dev.ws.yandex.ru',
            configs: [{
                cacheName: 'tvm',
                path: /^\/portal\/apiproxy\/tvm/,
                plugins: [
                    cacheKey.auth,
                ],
            }, {
                cacheName: 'blackbox',
                path: /^\/portal\/apiproxy\/blackbox/,
                plugins: [
                    cacheKey.auth,
                ],
            }, {
                cacheName: 'suggest',
                path: /^\/suggest/,
            }],
        },
        '3355': {
            url: 'https://test.gendarme.mail.yandex.net',
            configs: {
                cacheName: 'gendarme',
                path: /.*/,
            },
        },
        '3356': {
            url: 'https://test.sender.yandex-team.ru',
            configs: {
                cacheName: 'sender',
                path: /.*/,
            },
        },
        '3357': {
            url: 'http://bunker-api-dot.yandex.net',
            configs: {
                cacheName: 'bunker',
                path: /.*/,
            },
        },
        '3358': {
            url: 'https://test.dns-hosting.ws.yandex.net/api/v1',
            configs: {
                cacheName: 'dns',
                path: /.*/,
            },
        },
        '3359': {
            url: 'https://test.setter.mail.yandex.net',
            configs: {
                cacheName: 'setter',
                path: /.*/,
            },
        },
        '3360': {
            url: 'https://test.fouras.mail.yandex.net',
            configs: {
                cacheName: 'fouras',
                path: /.*/,
            },
        },
        '3361': {
            url: 'https://yandex.ru',
            configs: {
                cacheName: 'ya',
                path: /.*/,
            },
        },
    },
};
