function fetches(req, method, pathname) {
    return req.method === method && req.parsedURL.pathname === pathname;
}

function json(res, body, status = 200) {
    res.writeHead(status, {
        'content-type': 'application/json',
    });
    res.end(JSON.stringify(body));
}

/*
function hasHash(req, hash) {
    return hasSearchParam(req, '__hash__', hash);
}

function hasTestId(req, testId) {
    return (req.parsedURL.query['dumps-test-path'] || '').includes(`/${testId}`);
}

function hasSearchParam(req, key, value) {
    return req.parsedURL.query[key] === value;
}
*/

const directory = {
    controller: ({ req, res }, next) => {
        if (fetches(req, 'GET', '/v11/mail-migration/')) {
            return json(res, [
                { stage: 'accounts-creating', state: 'success' },
                { stage: 'collectors-creating', state: 'success' },
            ]);
        }

        if (fetches(req, 'GET', '/v11/subscription/persons/')) {
            return json(res, [
                {
                    client_id: 55527273,
                    person_id: 9412455,
                    email: 'xxx@email.com',
                    phone: '+0',
                    first_name: 'Mary',
                    last_name: 'Foo',
                    middle_name: '',
                    type: 'natural',
                },
                {
                    client_id: 71127273,
                    person_id: 2312455,
                    email: 'xxx@email.com',
                    phone: '+0',
                    first_name: 'Bob',
                    last_name: 'Bar',
                    middle_name: '',
                    type: 'legal',
                },
            ]);
        }

        next();
    },
};

module.exports = {
    directory,
};
