import { ActionTypes } from 'constants/Common';
import Url from 'lib/Url';
import AuthStore from 'stores/Auth';
import dispatcher from 'dispatcher';

export default {
    pushErrorId,
    showError,
};

function pushErrorId(requestId) {
    dispatcher.dispatch(ActionTypes.RECEIVE_MIXED_DATA, {
        state: { error_id: requestId },
    });
}

function showError() {
    const queryOptions = {
        retpath: location.href,
        eid: AuthStore.getState().get('error_id'),
    };

    const query = Object.keys(queryOptions)
        .map(key => `${key}=${encodeURIComponent(queryOptions[key])}`)
        .join('&');

    Url.open(Url.getLocation(Url.getPath(`error?${query}`)));
}
