import { Promise } from 'rsvp';
import _ from 'lodash';
import { ActionTypes } from 'constants/Common';
import dispatcher from 'dispatcher';
import restoreApi from 'api/org.restore';
import RestoreActions from 'actions/Restore';
import { start, succeed, fail } from './handlers';

export default {
    showActiveChecks,
    showNewRequest,
    showCheckStatus,
};

function showActiveChecks() {
    start();

    return restoreApi.getActiveChecks()
        .then(response => {
            dispatcher.dispatch(ActionTypes.RECEIVE_MIXED_DATA, _.merge(response, {
                restore: {
                    current_check: {},
                },
            }));
            succeed(response);
        })
        .catch(fail);
}

function showNewRequest() {
    dispatcher.dispatch(ActionTypes.RECEIVE_MIXED_DATA, {
        restore: {
            current_check: {},
            active_checks: [],
        },
    });

    return Promise.resolve();
}

function showCheckStatus(restoreId) {
    start();

    return RestoreActions.getStatus(restoreId)
        .then(() => succeed());
}
