import { Promise } from 'rsvp';
import subscriptionApi from 'api/subscription';
import { start, succeed, succeedAll, fail } from './handlers';

export default {
    showDetails,
    showPersons,
};

function showDetails() {
    start();

    return Promise.all([
        subscriptionApi.getState(),
        subscriptionApi.getPricing(),
    ])
        .then(succeedAll)
        .catch(fail);
}

function showPersons() {
    start();

    return subscriptionApi.getPersons().then(succeed)
        .catch(fail);
}
