import { ActionTypes } from 'constants/Common';
import dispatcher from 'dispatcher';
import getErrors from 'lib/getErrors';
import bunkerApi from 'api/bunker';

export default {
    fetchNodes,
};

function fetchNodes() {
    return bunkerApi.read().then(response => {
        const errors = getErrors(response);

        if (!errors.isEmpty()) {
            return { errors };
        }

        dispatcher.dispatch(ActionTypes.RECEIVE_MIXED_DATA, response);
    });
}
