import ModalActions from 'actions/Modal';
import CreateForm from 'components/Group/Forms/Create';
import { i18n } from 'lib/i18n';
import timer from 'lib/timer';

export default {
    create,
};

function create() {
    let isSubmitted;

    timer.start('create_group');

    ModalActions.open({
        title: i18n('group.new_group'),
        component: CreateForm,
        props: {
            onSubmit() {
                isSubmitted = true;
                ModalActions.close();
            },
            onCancel() {
                ModalActions.close();
                timer.clear('create_group');
            },
        },
        onClose() {
            if (!isSubmitted) {
                timer.clear('create_group');
            }
        },
    });
}
