import { ActionTypes } from 'constants/Common';
import dispatcher from 'dispatcher';

export default {
    editUser,
    userEdited,

    editDepartment,
    departmentEdited,

    editGroup,
    groupEdited,

    editGroupMembers,
    selectGroupMembers,
    groupMembersEdited,

    editOrganizationAdmins,
    selectOrganizationAdmins,
    organizationAdminsEdited,

    editOrgProfile,
    orgProfileEdited,

    typeNewDomain,
};

function editUser(data) {
    dispatcher.dispatch(ActionTypes.EDIT_USER, data);
}

function userEdited(id) {
    dispatcher.dispatch(ActionTypes.USER_EDITED, { id });
}

/**
 * "Редактировать отдел"
 * @method editDepartment
 * @param  {Object}  data  { component, props }  форма редактирования
 */
function editDepartment(data) {
    dispatcher.dispatch(ActionTypes.EDIT_DEPARTMENT, data);
}

/**
 * "Закончить действия с отделом"
 * @method departmentEdited
 * @param  {String}  id  редактируемый отдел
 */
function departmentEdited(id) {
    dispatcher.dispatch(ActionTypes.DEPARTMENT_EDITED, { id });
}

/**
 * "Редактировать команду"
 * @method editGroup
 * @param  {Object}  data  { component, props }  форма редактирования
 */
function editGroup(data) {
    dispatcher.dispatch(ActionTypes.EDIT_GROUP, data);
}

/**
 * "Закончить действия с командой"
 * @method groupEdited
 * @param  {String}  id  редактируемая команда
 */
function groupEdited(id) {
    dispatcher.dispatch(ActionTypes.GROUP_EDITED, { id });
}

/**
 * "Начать редактирование списка членов команды"
 * @method editGroupMembers
 * @param  {Object}  data  { id, type }  список членов команды
 */
function editGroupMembers(data) {
    dispatcher.dispatch(ActionTypes.EDIT_GROUP_MEMBERS, data);
}

/**
 * "Выбрать список членов команды"
 * @method selectGroupMembers
 * @param  {Object}  data  { id, type, list }  список членов команды
 */
function selectGroupMembers(data) {
    dispatcher.dispatch(ActionTypes.SELECT_GROUP_MEMBERS, data);
}

/**
 * "Закончить редактирование списка членов команды"
 * @method groupMembersEdited
 * @param  {Object}  data  { id, type }
 */
function groupMembersEdited(data) {
    dispatcher.dispatch(ActionTypes.GROUP_MEMBERS_EDITED, data);
}

/**
 * "Начать редактирование списка админов организации"
 * @method editOrganizationAdmins
 */
function editOrganizationAdmins() {
    dispatcher.dispatch(ActionTypes.EDIT_ORGANIZATION_ADMINS);
}

/**
 * "Выбрать список админов организации"
 * @method selectOrganizationAdmins
 * @param  {Object}  data  { list }  список админов организации
 */
function selectOrganizationAdmins(data) {
    dispatcher.dispatch(ActionTypes.SELECT_ORGANIZATION_ADMINS, data);
}

/**
 * "Закончить редактирование списка админов организации"
 * @method organizationAdminsEdited
 */
function organizationAdminsEdited() {
    dispatcher.dispatch(ActionTypes.ORGANIZATION_ADMINS_EDITED);
}

/**
 * "Редактировать информацию об организации"
 * @method editOrgProfile
 * @param  {Object}  data  { component }  форма редактирования
 */
function editOrgProfile(data) {
    dispatcher.dispatch(ActionTypes.EDIT_ORGANIZATION_PROFILE, data);
}

/**
 * "Закончить редактирование информации об организации"
 * @method orgProfileEdited
 */
function orgProfileEdited() {
    dispatcher.dispatch(ActionTypes.ORGANIZATION_PROFILE_EDITED);
}

/**
 * "Сохранить набранный в поле ввода новый домен организации"
 * @method typeNewDomain
 * @param  {Object}  data  { text }
 */
function typeNewDomain(data) {
    dispatcher.dispatch(ActionTypes.TYPE_NEW_DOMAIN, data);
}
