import _ from 'lodash';
import { requestApi } from 'lib/requestApi';

const api = {
    getRecords,
    submitRecord,
    removeRecord,
};

_.set(window.ya.connect, 'api.dns', api);

export default api;

function getRecords(domain) {
    return requestApi('GET', 'org/dns', {
        query: { domain },
    });
}

function submitRecord(domain, recordData) {
    return requestApi('POST', 'org/dns', {
        query: { domain },
        data: recordData,
    });
}

function removeRecord(domain, id) {
    return requestApi('DELETE', 'org/dns', {
        query: { domain, id },
    });
}
