import _ from 'lodash';
import { requestApi } from 'lib/requestApi';

const api = {
    getList,
    read,
    add,
    remove,
    checkOwnership,
    getConfirmationInfo,
};

_.set(window.ya.connect, 'api.domain', api);

export default api;

/**
 * Получаем список доменов организации
 * @returns {Promise}
 */
function getList() {
    return requestApi('GET', 'domains');
}

function read(name) {
    return requestApi('GET', 'domains', { query: { name } });
}

function add(name) {
    const data = {
        name,
    };

    return requestApi('POST', 'domains', { data });
}

function remove(name) {
    const query = {
        domain: name,
    };

    return requestApi('DELETE', 'domains', { query });
}

function checkOwnership(query) {
    return requestApi('POST', 'domains/ownership', { query });
}

function getConfirmationInfo(name) {
    const query = {
        domain: name,
    };

    return requestApi('GET', 'domains/ownership', { query });
}
