import _ from 'lodash';
import { requestApi } from 'lib/requestApi';

const api = {
    createUser,
    inviteByEmails,
    createInviteLink,
    readInviteLink,
    removeInviteLink,
};

_.set(window.ya.connect, 'api.invite', api);

function createUser(data) {
    return requestApi('POST', 'invites/use', { data });
}

function inviteByEmails(options) {
    return requestApi('POST', 'invites/emails', { data: options });
}

function createInviteLink(options) {
    return requestApi('POST', 'department/invite', { data: options });
}

function readInviteLink(options) {
    return requestApi('GET', 'department/invite', { query: options });
}

function removeInviteLink(options) {
    return requestApi('DELETE', 'department/invite', { data: options });
}

export default api;
