import _ from 'lodash';
import { requestApi } from 'lib/requestApi';

const api = {
    read,
    update,
    add,
};

_.set(window.ya.connect, 'api.license.requests', api);

function read() {
    return requestApi('GET', 'subscription/licenses/request');
}
function add(data) {
    return requestApi('POST', 'subscription/licenses/request', { data });
}

function update(options) {
    return requestApi('POST', `subscription/licenses/request/${options.action}/`, { data: options.requests });
}

export default api;
