import _ from 'lodash';
import { requestApi } from 'lib/requestApi';

const api = {
    read,
    update,
    calculate,
};

_.set(window.ya.connect, 'api.licenses', api);

function read(serviceSlug) {
    return requestApi('GET', 'subscription/licenses', {
        query: { service: serviceSlug },
    });
}

function update(serviceSlug, data) {
    return requestApi('PUT', 'subscription/licenses', {
        data,
        query: { service: serviceSlug },
    });
}

function calculate(serviceSlug, data) {
    return requestApi('POST', 'subscription/calculate', {
        data,
        query: { service: serviceSlug },
    });
}

export default api;
