import _ from 'lodash';
import { requestApi } from 'lib/requestApi';

const api = {
    getSettings,
    updateSettings,
    getDkimStatus,
    enableDkim,
    checkImportServer,
    startImport,
    getImportStatus,
};

_.set(window.ya.connect, 'api.mail', api);

export default api;

function getSettings() {
    return requestApi('GET', 'mail/settings');
}

function updateSettings(data) {
    return requestApi('POST', 'mail/settings', { data });
}

function getDkimStatus(domain) {
    return requestApi('GET', 'mail/dkim/status', { query: { domain } });
}

function enableDkim(domains) {
    return requestApi('POST', 'mail/dkim/enable', { data: { domains } });
}

function checkImportServer(options) {
    return requestApi('GET', 'mail/check-import-server', { query: options });
}

function startImport(options) {
    return requestApi('POST', 'mail/import', { data: options });
}

function getImportStatus(options) {
    return requestApi('GET', 'mail/import', { query: options });
}
