import _ from 'lodash';
import { requestApi } from 'lib/requestApi';

const api = {
    read,
    update,
    setLogo,
    removeLogo,
};

_.set(window.ya.connect, 'api.org.profile', api);

export default api;

function read() {
    return requestApi('GET', 'org/profile');
}

function update(data) {
    return requestApi('PATCH', 'org/profile', { data });
}

function setLogo(data, id) {
    return requestApi('POST', 'org/logo', { query: { id }, data, timeout: 60000 });
}

function removeLogo(id) {
    return requestApi('DELETE', 'org/logo', { query: { id }, timeout: 60000 });
}
