import _ from 'lodash';
import { requestApi } from 'lib/requestApi';

const api = {
    getCurrentOwner,
    getActiveChecks,
    getCheckStatus,
    start,
    getOwnershipStatus,
    checkOwnership,
};

_.set(window.ya.connect, 'api.org.restore', api);

export default api;

function getCurrentOwner(domain) {
    return requestApi('GET', 'org/restore/current-owner', { query: { domain } });
}

function getActiveChecks() {
    return requestApi('GET', 'org/restore');
}

function getCheckStatus(restoreId) {
    return requestApi('GET', 'org/restore', { query: { restore_id: restoreId } });
}

function start(data) {
    return requestApi('POST', 'org/restore', { data });
}

function getOwnershipStatus(restoreId) {
    return requestApi('GET', 'org/restore/ownership', { query: { restore_id: restoreId } });
}

function checkOwnership(restoreId, data) {
    return requestApi('POST', 'org/restore/ownership', { query: { restore_id: restoreId }, data });
}
