import _ from 'lodash';
import { requestApi, requestServiceApi } from 'lib/requestApi';

const api = {
    getList,
    getServiceList,
    checkAuth,
};

_.set(window.ya.connect, 'api.permissions', api);

export default api;

/**
 * Получаем глобальные права
 * @param {Object} options
 * @returns {Promise}
 */
function getList(options) {
    return requestApi('GET', 'permissions', { query: options });
}

function getServiceList(service) {
    return requestApi('GET', 'permissions/service', { query: { type: service } });
}

function checkAuth() {
    return requestServiceApi('GET', 'ping');
}
