import _ from 'lodash';
import { requestApi } from 'lib/requestApi';

const api = {
    read,
    count,
    remove,
    readRoles,
    readRelations,
    createRelation,
    removeRelation,
    readRequests,
    confirmRequest,
    denyRequest,
};

_.set(window.ya.connect, 'api.resources', api);

function read(options) {
    return requestApi('GET', 'resources', { query: options });
}

function count(options) {
    return requestApi('GET', 'resources/count', { query: options });
}

function remove(options) {
    return requestApi('DELETE', 'resources', { query: options });
}

function readRoles(options) {
    return requestApi('GET', 'resources/roles', { query: options });
}

function createRelation(data) {
    return requestApi('POST', 'relations', { data });
}

function removeRelation(data) {
    return requestApi('DELETE', 'relations', { data });
}

function readRequests(options) {
    return requestApi('GET', 'resources/requests', { query: options });
}

function readRelations(options) {
    return requestApi('GET', 'resources/relations', { query: options });
}

function confirmRequest(data) {
    return requestApi('POST', 'resources/requests/confirm', { data });
}

function denyRequest(data) {
    return requestApi('POST', 'resources/requests/deny', { data });
}

export default api;
