import _ from 'lodash';
import { requestApi } from 'lib/requestApi';

const api = {
    readAll,
    readMenu,
    update,
};

_.set(window.ya.connect, 'api.services', api);

export default api;

function readAll() {
    return requestApi('GET', 'services');
}

function readMenu() {
    return requestApi('GET', 'services/menu');
}

function update(service, data) {
    return requestApi('PATCH', 'services', { query: { service }, data });
}
