import _ from 'lodash';
import { requestApi } from 'lib/requestApi';

const api = {
    read,
    update,
    remove,
};

_.set(window.ya.connect, 'api.settings', api);

export default api;

function read() {
    return requestApi('GET', 'settings');
}

function update(data) {
    return requestApi('PUT', 'settings', { data });
}

function remove() {
    return requestApi('DELETE', 'settings');
}
