import _ from 'lodash';
import { requestApi } from 'lib/requestApi';

const api = {
    getState,
    getPricing,
    pay,
    createContract,
    activatePromoCode,
    toggleService,
    enableService,
    disableService,
    getPersons,
};

_.set(window.ya.connect, 'api.subscription', api);

export default api;

function getState() {
    return requestApi('GET', 'subscription');
}

function getPricing() {
    return requestApi('GET', 'subscription/pricing');
}

function pay(data) {
    return requestApi('POST', 'subscription/pay', { data });
}

function createContract(data) {
    return requestApi('POST', 'subscription/contract', { data });
}

function getPersons(data) {
    return requestApi('GET', 'subscription/persons', { data });
}

function activatePromoCode(data) {
    return requestApi('POST', 'subscription/promocodes/activate', { data });
}

function toggleService(name, enable, data) {
    const query = {
        name,
        action: enable ? 'enable' : 'disable',
    };

    return requestApi('POST', 'org/services', { query, data });
}

function enableService(name) {
    return toggleService(name, true);
}

function disableService(name) {
    return toggleService(name, false);
}
