import APIClient from '@connect/api-client';

const token = document.querySelector('meta[name="csrf_token"]').content;
const { state: { session: uid, organization: orgId }, requestId } = window.ya.connect.initial;

export default new APIClient(`/portal/apiproxy/org/${orgId}/dns`, {
    mode: 'cors',
    cache: 'no-cache',
    credentials: 'include',
    headers: {
        Accept: 'application/json',
        'Content-Type': 'application/json',
        'Cache-Control': 'no-cache',
        Pragma: 'no-cache',
        'x-csrf-token': token,
        'x-uid': uid,
        'x-org-id': orgId,
        'x-request-id': requestId,
        'x-client-version': window.ya.connect.config.app.version,
    },
});
