import APIClient from '@connect/api-client';
import { SessionStore } from 'lib2/stores';

let apiClient = new APIClient('/suggest/', {
    mode: 'cors',
    cache: 'no-cache',
    credentials: 'include',
    headers: {
        Accept: 'application/json',
        'x-request-id': window.ya.connect.initial.requestId,
        'x-client-version': window.ya.connect.config.app.version,
    },
});

export function search(params) {
    if (!params || !params.text) {
        return Promise.resolve({ ok: true, body: null });
    }

    const Defaults = {
        version: 2,
        layers: 'people,groups,departments',
        language: SessionStore.get('current.locale'),
        org_id: SessionStore.get('context.org_id'),
    };

    return apiClient.send('GET', '', { query: { ...Defaults, ...params } });
}

export default apiClient;
