import AuthStore from 'stores/Auth';
import ConfigStore from 'stores/Config';
import SettingsStore from 'stores/Settings';
import SettingsActions from 'actions/Settings';
import ModalActions from 'actions/Modal';
import { i18n } from 'lib/i18n';
import Url from 'lib/Url';

const SLIDE_SET = {
    admin: [1],
    staff: [2, 3],
};

const SettingsKeys = {
    USER_AGREEMENT: 'initial_user_agreement',
};

function getSlides() {
    return (SLIDE_SET[AuthStore.getViewMode()] || []).map(index => ({
        content: i18n(`intro.portal_${index}`, {
            help_url: ConfigStore.getHelpUrl('ui.help.main', { tld: ConfigStore.get('app.tld') }),
        }),
        id: index,
    }));
}

// слайды общего онбординга
export function showIntro() {
    if (!Url.getInitialAction()) {
        ModalActions.openIntro({
            id: `${AuthStore.getViewMode()}_intro`,
            items: getSlides(),
            mod: 'portal-intro',
            appearsOnce: true,
        });
    }
}

// попап с пользовательским соглашением для админов
export function showUserAgreement() {
    const shouldRender = !SettingsStore.get(SettingsKeys.USER_AGREEMENT) &&
        AuthStore.isAdmin() &&
        AuthStore.isPartnerOrganization();

    if (!shouldRender) {
        return;
    }

    let agreementAccepted;

    ModalActions.confirm({
        message: i18n('intro.user_agreement.content', {
            user_agreement_url: ConfigStore.get('ui.help.partner_user_agreement'),
        }),
        confirmButtonText: i18n('intro.user_agreement.action.accept'),
        rejectButtonText: i18n('intro.user_agreement.action.decline'),
        onConfirm: () => {
            SettingsActions.updateSettings({
                [SettingsKeys.USER_AGREEMENT]: (new Date()).toISOString(),
            });
            agreementAccepted = true;
        },
        onClose: () => {
            if (!agreementAccepted) {
                Url.open(Url.getLocation(Url.getPath('/home')));
            }
        },
    });
}
