import React from 'react';
import { Permissions } from 'constants/Common';
import StoreMixin from 'lib/StoreMixin';

import PermissionStore from 'stores/Permissions';
import SubscriptionStore from 'stores/Subscription';

import { i18n, formatCurrency, formatDate } from 'lib/i18n';
import MakePayment from './Forms/MakePayment';

const Payment = React.createClass({

    mixins: [StoreMixin],

    getStoreState() {
        return {
            balance: SubscriptionStore.getBalance() || 0,
        };
    },

    componentDidMount() {
        this.subscribe([SubscriptionStore, PermissionStore]);
    },

    render() {
        if (!PermissionStore.contains(Permissions.PAY)) {
            return null;
        }

        const { balance } = this.state;

        const className = [
            'balance__payment',
            balance < 0 ? 'balance__payment_negative' : null,
        ].filter(Boolean).join(' ');

        const title = i18n('balance.current_balance', {
            amount: formatCurrency(balance, 'RUB'),
        });

        return (
            <div className={className}>
                <div className="balance__payment__header">
                    <h2
                        className="balance__payment__title"
                        dangerouslySetInnerHTML={{ __html: title }}
                    />
                </div>
                <div className="balance__payment__body">
                    <Payment.Description balance={balance} />
                    <MakePayment />
                </div>
            </div>
        );
    },

});

Payment.Description = props => {
    let content;
    const paymentDueDate = SubscriptionStore.get('current.payment_due_date');

    if (props.balance < 0 && paymentDueDate) {
        content = i18n('subscription.balance.description.negative_amount', {
            date: formatDate(paymentDueDate),
        });
    }

    return (
        <div
            className="balance__payment__description"
            dangerouslySetInnerHTML={{ __html: content }}
        />
    );
};

export default Payment;
