import { i18n } from 'lib/i18n';
import ConfigStore from 'stores/Config';

const PricingInfo = () => {
    const base = 'balance__pricing-info';

    const content = i18n('balance.pricing_info.content', {
        pricing_url: ConfigStore.getHelpUrl('ui.help.billing'),
        payment_timeline_url: ConfigStore.get('ui.help.billing_acts'),
        offer_url: ConfigStore.get('ui.help.offer'),
    });

    return (
        <div className={base}>
            <h2 className={`${base}__title`}>
                {i18n('balance.pricing_info.title')}
            </h2>
            <div
                className={`${base}__content`}
                dangerouslySetInnerHTML={{ __html: content }}
            />
        </div>
    );
};

export default PricingInfo;
