import React from 'react';
import { block } from 'bem-cn';
import { Button, Link } from 'lego-on-react';

import ConfigStore from 'stores/Config';
import { i18n } from 'lib/i18n';

import './index.css';

const bBindWidgetPromo = block('bind-promo');

// Сделал через React.createClass потому что для stateless компонента
// в колбек в ref на BindPromo передавался null
const BindPromo = React.createClass({
    _getText(key) {
        const { hasOrg, serviceSlug, type } = this.props;
        let section = hasOrg ? 'with_org' : 'without_org';

        if (type !== 'normal') {
            section = type;
        }

        return i18n(`bind_promo.${section}.${serviceSlug}.${key}`) ||
            i18n(`bind_promo.${section}.default.${key}`);
    },

    _getControls() {
        const { onConfirm, serviceSlug, type } = this.props;
        const buttonProps = {
            theme: 'action',
            view: 'default',
            tone: 'default',
            size: 'm',
        };

        if (type === 'adv') {
            return [
                <Button
                    {...buttonProps}
                    key="control-adv-1"
                    type="link"
                    target="_blank"
                    cls={bBindWidgetPromo('confirm-button')}
                    url={ConfigStore.getServiceBindSubscribeUrl(serviceSlug)}
                >
                    {this._getText('confirm_button', type)}
                </Button>,
                <Button
                    {...buttonProps}
                    key="control-adv-2"
                    type="link"
                    target="_blank"
                    cls={bBindWidgetPromo('confirm-button', { small: true })}
                    url={ConfigStore.getServiceBindSubscribeUrl(serviceSlug)}
                >
                    {i18n('bind_promo.adv.confirm_button_small')}
                </Button>,
                <Link
                    theme="normal"
                    target="_blank"
                    key="control-adv-3"
                    url={ConfigStore.getServiceBindMoreUrl(serviceSlug)}
                    cls={bBindWidgetPromo('about-link')}
                    text={i18n('bind_promo.more')}
                />,
            ];
        }

        return [
            <Button
                {...buttonProps}
                key="control-normal-1"
                cls={bBindWidgetPromo('confirm-button')}
                onClick={onConfirm}
            >
                {this._getText('confirm_button')}
            </Button>,
            <Button
                {...buttonProps}
                key="control-normal-2"
                cls={bBindWidgetPromo('confirm-button', { small: true })}
                onClick={onConfirm}
            >
                {i18n('bind_promo.confirm_button_small')}
            </Button>,
            <Link
                theme="normal"
                target="_blank"
                key="control-normal-3"
                url={ConfigStore.getServiceBindAdvantagesUrl(serviceSlug)}
                cls={bBindWidgetPromo('about-link')}
                text={i18n('bind_promo.about')}
            />,
            <Link
                theme="normal"
                target="_blank"
                key="control-normal-4"
                url={ConfigStore.getServiceBindFaqUrl(serviceSlug)}
                cls={bBindWidgetPromo('about-link')}
                text={i18n('bind_promo.faq')}
            />,
        ];
    },

    render() {
        const { isBeta, type } = this.props;

        return (
            <div className={bBindWidgetPromo}>
                {isBeta && <div className={bBindWidgetPromo('beta')}>βeta</div>}
                <div className={bBindWidgetPromo('pic')} />
                <div className={bBindWidgetPromo('content')}>
                    <h3 className={bBindWidgetPromo('title')}>
                        {this._getText('title', type)}
                    </h3>
                    <p className={bBindWidgetPromo('description')}>
                        {this._getText('description', type)}
                    </p>
                    <div className={bBindWidgetPromo('controls')}>
                        {this._getControls()}
                    </div>
                </div>
            </div>
        );
    },
});

export default BindPromo;
