import PropTypes from 'prop-types';
import React from 'react';

import { Button, Link } from 'lego-on-react';

import { block } from 'bem-cn';
import ConfigStore from 'stores/Config';

import { i18n } from 'lib/i18n';

import './bind-widget-success.css';
const bBindWidgetSuccess = block('bind-widget-success');

const BindWidgetSuccess = React.createClass({

    _getText(key, params) {
        const { serviceSlug } = this.props;

        return i18n(`${key}.${serviceSlug}`, params) || i18n(`${key}.default`, params);
    },

    render() {
        const { onCancel, orgName, serviceSlug } = this.props;
        let title;

        if (orgName) {
            title = `${this._getText('bind.widget.success.title.org')}\n«${orgName}»`;
        } else {
            title = this._getText('bind.widget.success.title');
        }

        return (
            <div className={bBindWidgetSuccess()}>
                <div className={bBindWidgetSuccess('icon')} />
                <div
                    className={bBindWidgetSuccess('title')}
                >
                    {title}
                </div>
                <Button
                    theme="action"
                    view="default"
                    tone="default"
                    size="m"
                    cls={bBindWidgetSuccess('button')}
                    onClick={onCancel}
                >
                    {i18n('bind.widget.success.button.cancel')}
                </Button>
                <div className={bBindWidgetSuccess('link')}>
                    <Link
                        theme="normal"
                        text={i18n('bind.widget.link.text.connect')}
                        target="_blank"
                        url={ConfigStore.getServiceBindAdvantagesUrl(serviceSlug)}
                    />
                </div>
                <div className={bBindWidgetSuccess('link')}>
                    <Link
                        theme="normal"
                        target="_blank"
                        text={i18n('bind.widget.link.text.faq')}
                        url={ConfigStore.getServiceBindFaqUrl(serviceSlug)}
                    />
                </div>
            </div>
        );
    },
});

BindWidgetSuccess.propTypes = {
    onCancel: PropTypes.func.isRequired,
    serviceSlug: PropTypes.string,
    orgName: PropTypes.string,
};

export default BindWidgetSuccess;
